﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Xml;
using System.Net;
using System.IO;

namespace DopisOnlineAPI
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Test nahrani souboru na server pres API\r\n");  

            string fileName = "DopisOnline.xml";
            if (args.Length == 1)
            {
                fileName = args[0].Trim();
            }

            if (File.Exists(fileName))
            {
                File.Delete("response.xml");

                Program.PostDopisOnline("http://online3.postservis.cz/dopisonline/donApi.php", "dreplech", "dreplech", fileName);
                if (File.Exists("response.xml"))
                {
                    Console.WriteLine("Kod objednavky: " + parseXml("response.xml", "kod_objednavky"));
                    Console.WriteLine("Podaci cislo:   " + parseXml("response.xml", "podaci_cislo"));
                    Console.WriteLine("Datum podani:   " + parseXml("response.xml", "datum_podani"));
                }                

            }
            else
            {
                Console.WriteLine("Soubor se nepodarilo najit!");
                Console.ReadLine();
            }          
           
            Console.ReadLine();

        }

        public static string parseXml(string file, string el)
        {
            string element = "";
            string hodnota = "";
            string tmp = "";
            XmlReader reader = XmlReader.Create(file);
            while (reader.Read())
            {
                if (reader.NodeType == XmlNodeType.Element)
                {
                    element = reader.Name;
                    if (element == "chyby")
                    {
                        hodnota = reader.GetAttribute("stav");
                    }
                }
                else if (reader.NodeType == XmlNodeType.Text)
                {

                    if (element == el)
                    {
                        if (hodnota == "0")
                        {
                            tmp = reader.Value;
                        }
                    }

                }


            }

            return tmp;
        }

        public static void PostDopisOnline(string url, string user, string password, string file)
        {
            Console.WriteLine(System.String.Format("Probiha nahrani souboru {0} na server {1}\r\n", file, url));           
            string boundary = "----------------------------" + DateTime.Now.Ticks.ToString("x");
            HttpWebRequest httpWebRequest = (HttpWebRequest)WebRequest.Create(url);
            httpWebRequest.ContentType = "multipart/form-data; boundary=" + boundary;
            httpWebRequest.Method = "POST";
            httpWebRequest.KeepAlive = true;
            httpWebRequest.Credentials = System.Net.CredentialCache.DefaultCredentials;

            Stream memStream = new System.IO.MemoryStream();

            byte[] boundarybytes = System.Text.Encoding.ASCII.GetBytes("\r\n--" + boundary + "\r\n");

            string formdataTemplate = "\r\n--" + boundary + "\r\nContent-Disposition:  form-data; name=\"user\";\r\n\r\n{1}";

            memStream.Write(boundarybytes, 0, boundarybytes.Length);
            string formitem = string.Format(formdataTemplate, "user", user);
            byte[] formitembytes = System.Text.Encoding.UTF8.GetBytes(formitem);
            memStream.Write(formitembytes, 0, formitembytes.Length);

            formdataTemplate = "\r\n--" + boundary + "\r\nContent-Disposition:  form-data; name=\"password\";\r\n\r\n{1}";

            memStream.Write(boundarybytes, 0, boundarybytes.Length);
            formitem = string.Format(formdataTemplate, "password", password);
            formitembytes = System.Text.Encoding.UTF8.GetBytes(formitem);
            memStream.Write(formitembytes, 0, formitembytes.Length);

            string headerTemplate = "Content-Disposition: form-data; name=\"soubor\"; filename=\"{1}\"\r\n Content-Type: {2}\r\n\r\n";
            memStream.Write(boundarybytes, 0, boundarybytes.Length);
            string header = string.Format(headerTemplate, "soubor", file, "multipart/form-data");
            byte[] headerbytes = System.Text.Encoding.UTF8.GetBytes(header);
            memStream.Write(headerbytes, 0, headerbytes.Length);

            FileStream fileStream = new FileStream(file, FileMode.Open,
            FileAccess.Read);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = fileStream.Read(buffer, 0, buffer.Length)) != 0)
            {
                memStream.Write(buffer, 0, bytesRead);
            }
            memStream.Write(boundarybytes, 0, boundarybytes.Length);
            fileStream.Close();

            httpWebRequest.ContentLength = memStream.Length;
            Stream requestStream = httpWebRequest.GetRequestStream();
            memStream.Position = 0;
            byte[] tempBuffer = new byte[memStream.Length];
            memStream.Read(tempBuffer, 0, tempBuffer.Length);
            memStream.Close();
            requestStream.Write(tempBuffer, 0, tempBuffer.Length);
            requestStream.Close();
            try
            {
                WebResponse webResponse = httpWebRequest.GetResponse();
                Stream stream = webResponse.GetResponseStream();
                StreamReader reader = new StreamReader(stream);

                StreamWriter sWriter = new StreamWriter("response.xml", true, Encoding.GetEncoding("utf-8"));
                sWriter.Write(reader.ReadToEnd());
                sWriter.Close();

                Console.WriteLine("Soubor byl nahran na server\r\n");
                Console.WriteLine("Vysledek byl zapsan do souboru response.xml\r\n");
                Console.WriteLine("HOTOVO!!!\r\n");

            }
            catch (Exception ex)
            {
                Console.WriteLine("Chyba pri nahravani souboru na server: " + ex.Message);
                Console.ReadLine();
            }
            httpWebRequest = null;
        }          

    }
}
